/*
 * Decompiled with CFR 0.152.
 */
package com.pgyer.uploadpugin.http;

import com.pgyer.uploadpugin.entity.ApkInformation;
import com.pgyer.uploadpugin.http.ProgressHttpEntityWrapper;
import com.pgyer.uploadpugin.http.UploadFileToServiceCallback;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class UploadService
implements ProgressHttpEntityWrapper.ProgressCallback {
    private static String url = "https://www.pgyer.com/apiv2/app/upload";
    private UploadFileToServiceCallback uploadFileToServiceCallback;
    private String backData;

    public void uploadFileToServer(final Map<String, String> params, final File files, final UploadFileToServiceCallback uploadFileToServiceCallback) {
        this.uploadFileToServiceCallback = uploadFileToServiceCallback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int code = UploadService.this.uploadFiles(url, params, files);
                    if (code == 200) {
                        if (uploadFileToServiceCallback != null) {
                            uploadFileToServiceCallback.onUploadFinished(true, code);
                        }
                    } else if (uploadFileToServiceCallback != null) {
                        uploadFileToServiceCallback.onUploadFinished(false, code);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    uploadFileToServiceCallback.onUploadError(-1, UploadService.this.backData);
                }
            }
        }).start();
    }

    private int uploadFiles(String url, Map<String, String> params, File files) throws ClientProtocolException, IOException, JSONException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addBinaryBody("file", files);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            System.out.println(entry.getKey() + "--->" + entry.getValue());
            builder.addTextBody(entry.getKey(), entry.getValue());
            if (!entry.getKey().equals("buildUpdateDescription")) continue;
            builder.addTextBody(entry.getKey(), entry.getValue(), ContentType.create((String)entry.getValue(), (Charset)Charset.forName("UTF-8")));
        }
        if (this.uploadFileToServiceCallback != null) {
            this.uploadFileToServiceCallback.onPackageSizeComputed(100L);
        }
        HttpEntity entity = builder.build();
        post.setEntity((HttpEntity)new ProgressHttpEntityWrapper(entity, this));
        HttpResponse response = client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() == 200) {
            String responseString;
            this.backData = responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            JSONObject jsonObject = new JSONObject(responseString);
            JSONObject data = jsonObject.getJSONObject("data");
            String appShort = data.getString("buildShortcutUrl");
            ApkInformation.getInstance().setaShort("http://www.pgyer.com/" + appShort);
            return response.getStatusLine().getStatusCode();
        }
        return response.getStatusLine().getStatusCode();
    }

    @Override
    public void progress(float progress) {
        this.uploadFileToServiceCallback.onProgressChanged(progress);
    }
}

