/*
 * Decompiled with CFR 0.152.
 */
package com.pgyer.uploadpugin.utils;

import com.pgyer.uploadpugin.entity.ApkInformation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileOperate {
    private static FileOperate fileOperate = new FileOperate();

    public static FileOperate getInstance() {
        return fileOperate;
    }

    public void newFolder(String folderPath) {
        try {
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            if (!myFilePath.exists()) {
                myFilePath.mkdir();
            }
        }
        catch (Exception e) {
            System.out.println("");
            e.printStackTrace();
        }
    }

    public void newFile(String filePathAndName, String fileContent) {
        try {
            String filePath = filePathAndName;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            if (!myFilePath.exists()) {
                myFilePath.createNewFile();
            }
            FileWriter resultFile = new FileWriter(myFilePath);
            PrintWriter myFile = new PrintWriter(resultFile);
            String strContent = fileContent;
            myFile.println(strContent);
            myFile.flush();
            myFile.close();
            resultFile.close();
        }
        catch (Exception e) {
            System.out.println("");
            e.printStackTrace();
        }
    }

    public Boolean isExist(String path) {
        File file = new File(path);
        return file.exists();
    }

    public void delFile(String filePathAndName) {
        try {
            String filePath = filePathAndName;
            filePath = filePath.toString();
            File myDelFile = new File(filePath);
            myDelFile.delete();
        }
        catch (Exception e) {
            System.out.println("");
            e.printStackTrace();
        }
    }

    public void delFolder(String folderPath) {
        try {
            this.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            System.out.println("");
            e.printStackTrace();
        }
    }

    public void delAllFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            this.delAllFile(path + "/" + tempList[i]);
            this.delFolder(path + "/" + tempList[i]);
        }
    }

    public void copyFile(String oldPath, String newPath) {
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    System.out.println(bytesum += byteread);
                    fs.write(buffer, 0, byteread);
                }
                fs.flush();
                fs.close();
                ((InputStream)inStream).close();
            }
        }
        catch (Exception e) {
            System.out.println("");
            e.printStackTrace();
        }
    }

    public void copyFolder(String oldPath, String newPath) {
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(newPath + "/" + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (!temp.isDirectory()) continue;
                this.copyFolder(oldPath + "/" + file[i], newPath + "/" + file[i]);
            }
        }
        catch (Exception e) {
            System.out.println("");
            e.printStackTrace();
        }
    }

    public void moveFile(String oldPath, String newPath) {
        this.copyFile(oldPath, newPath);
        this.delFile(oldPath);
    }

    public void moveFolder(String oldPath, String newPath) {
        this.copyFolder(oldPath, newPath);
        this.delFolder(oldPath);
    }

    public String fileChoose() {
        JFileChooser fileChooser = new JFileChooser(ApkInformation.getInstance().filePath);
        FileNameExtensionFilter ff = new FileNameExtensionFilter(null, "apk");
        fileChooser.setFileFilter(ff);
        int option = fileChooser.showOpenDialog(null);
        if (option == 0) {
            String path = fileChooser.getSelectedFile().getAbsolutePath();
            return path;
        }
        return null;
    }
}

