/*
 * Decompiled with CFR 0.152.
 */
package com.pgyer.uploadpugin.utils;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class Utils {
    public static String validateString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static FileChooserDescriptor createSingleFileDescriptor(FileType fileType) {
        return new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return file.isDirectory() || file.getPath().toLowerCase().contains(".apk");
            }

            public boolean isFileSelectable(VirtualFile file) {
                return super.isFileSelectable(file) && file.getPath().toLowerCase().contains(".apk");
            }
        };
    }

    public static void postNoticeTOSlack(String msg) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                CloseableHttpClient defaultHttpClient = HttpClientBuilder.create().build();
                String postUrl = "https://hooks.slack.com/services/T0284BTQB/B0326AP4F/YUL4";
                HttpPost httppost = new HttpPost(postUrl);
                HttpResponse response = null;
                ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
                JSONObject obj = new JSONObject();
                postParameters.add(new BasicNameValuePair("payload", obj.toString().replace("[", "").replace("]", "")));
                try {
                    httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                try {
                    response = defaultHttpClient.execute((HttpUriRequest)httppost);
                    HttpEntity entity = response.getEntity();
                    String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (IOException e) {
                    Utils.postErrorNoticeTOSlack(e);
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static void postSuccessNoticeToSlack(String msg) {
        Utils.postNoticeTOSlack("#AndroidStudio#success#" + msg);
    }

    public static void postErrorNoticeTOSlack(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)writer, true));
        Utils.postNoticeTOSlack("#AndroidStudio#Error#" + writer.toString());
    }

    public static void local() {
        Locale locale = Locale.getDefault();
        System.out.println(locale.getLanguage());
        System.out.println(locale.getCountry());
        String language = locale.getLanguage();
        String country = locale.getCountry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMd5(String path) {
        String value = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (FileInputStream fis = new FileInputStream(path);){
                byte[] dataBytes = new byte[1024];
                int nRead = 0;
                while ((nRead = fis.read(dataBytes)) != -1) {
                    md.update(dataBytes, 0, nRead);
                }
                byte[] mBytes = md.digest();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < mBytes.length; ++i) {
                    sb.append(Integer.toString((mBytes[i] & 0xFF) + 256, 16).substring(1));
                }
                System.out.println("Digest(in hex format):: " + sb.toString());
                value = sb.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }
}

