/*
 * Decompiled with CFR 0.152.
 */
package com.pgyer.uploadpugin.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public class ProgressHttpEntityWrapper
extends HttpEntityWrapper {
    private final ProgressCallback progressCallback;

    public ProgressHttpEntityWrapper(HttpEntity entity, ProgressCallback progressCallback) {
        super(entity);
        this.progressCallback = progressCallback;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.wrappedEntity.writeTo(out instanceof ProgressFilterOutputStream ? out : new ProgressFilterOutputStream(out, this.progressCallback, this.getContentLength()));
    }

    static class ProgressFilterOutputStream
    extends FilterOutputStream {
        private final ProgressCallback progressCallback;
        private long transferred;
        private long totalBytes;

        ProgressFilterOutputStream(OutputStream out, ProgressCallback progressCallback, long totalBytes) {
            super(out);
            this.progressCallback = progressCallback;
            this.transferred = 0L;
            this.totalBytes = totalBytes;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.transferred += (long)len;
            this.progressCallback.progress(this.getCurrentProgress());
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.transferred;
            this.progressCallback.progress(this.getCurrentProgress());
        }

        private float getCurrentProgress() {
            return (float)this.transferred / (float)this.totalBytes * 100.0f;
        }
    }

    public static interface ProgressCallback {
        public void progress(float var1);
    }
}

