/*
 * Decompiled with CFR 0.152.
 */
package com.pgyer.uploadpugin.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.pgyer.uploadpugin.entity.ApkInformation;
import com.pgyer.uploadpugin.http.UploadFileToServiceCallback;
import com.pgyer.uploadpugin.http.UploadService;
import com.pgyer.uploadpugin.ui.UpLoadInfoDialog;
import com.pgyer.uploadpugin.utils.RoundedBorder;
import com.pgyer.uploadpugin.utils.SearchFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import org.apache.http.util.TextUtils;

public class UploadFileDialog
extends JDialog
implements UploadFileToServiceCallback {
    private JPanel contentPane;
    private JButton btnUp;
    private JButton btnClose;
    private JLabel tvNameT;
    private JLabel tvNameV;
    private JLabel tvVersionT;
    private JLabel tvVersionV;
    private JLabel tvPackageNameT;
    private JLabel tvPackageNameV;
    private JLabel tvChannelT;
    private JLabel tvChannelV;
    private JLabel tvInstallTypeT;
    private JLabel tvInstallTypeV;
    private JLabel tvInstallPwdT;
    private JLabel tvInstallPwdV;
    private JLabel tvApiKeyT;
    private JLabel tvApiKeyV;
    private JProgressBar progressBar;
    private JLabel tvUploadSuccessful;
    private JLabel tvDownLoadT;
    private JLabel tvDownLoadV;
    private JButton btnUpload;
    private JLabel iconimage;
    public ApkInformation apkInformation;
    public UploadService uploadService;
    private Project project;

    public UploadFileDialog(Project project) {
        this.project = project;
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.setResizable(false);
        this.setMinimumSize(new Dimension(410, 400));
        this.setLocationRelativeTo(this.getParentWindow(project));
        this.getRootPane().setDefaultButton(this.btnClose);
        this.uploadService = new UploadService();
        this.apkInformation = ApkInformation.getInstance();
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadFileDialog.this.onUp();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadFileDialog.this.onClose();
            }
        });
        this.btnUpload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadFileDialog.this.uploadBuild();
            }
        });
        this.tvDownLoadV.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                UploadFileDialog.this.browserUrl(UploadFileDialog.this.apkInformation.getaShort());
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UploadFileDialog.this.apkInformation.getIcon() != null) {
                    String iconpath = SearchFile.getInstance().queryIcon(UploadFileDialog.this.apkInformation.getIcon());
                    Image image = Toolkit.getDefaultToolkit().getImage(iconpath);
                    ImageIcon icon_ = new ImageIcon(image);
                    icon_.setImage(icon_.getImage().getScaledInstance(45, 45, 16));
                    UploadFileDialog.this.iconimage.setIcon(icon_);
                } else {
                    ImageIcon icon_ = new ImageIcon("icon.png");
                    icon_.setImage(icon_.getImage().getScaledInstance(45, 45, 16));
                    UploadFileDialog.this.iconimage.setIcon(icon_);
                }
                UploadFileDialog.this.iconimage.setBorder(new RoundedBorder(10));
                UploadFileDialog.this.iconimage.setVisible(true);
            }
        });
        this.tvNameV.setText(this.apkInformation.getName());
        this.tvVersionV.setText(this.apkInformation.getVersionName() + "(" + this.apkInformation.getVersionCode() + ")");
        this.tvPackageNameV.setText(this.apkInformation.getBundleId());
        if (!TextUtils.isEmpty((CharSequence)this.apkInformation.getBuildChannelShortcut())) {
            this.tvChannelV.setText(this.apkInformation.getBuildChannelShortcut());
            this.tvChannelT.setVisible(true);
            this.tvChannelV.setVisible(true);
        } else {
            this.tvChannelT.setVisible(false);
            this.tvChannelV.setVisible(false);
        }
        if (this.apkInformation.getBuildInstallType().equals("2")) {
            this.tvInstallPwdT.setVisible(true);
            this.tvInstallPwdV.setVisible(true);
            this.tvInstallPwdV.setText(this.apkInformation.getBuildPassword());
            this.tvInstallTypeV.setText("\u5bc6\u7801\u5b89\u88c5");
        } else {
            this.tvInstallPwdT.setVisible(false);
            this.tvInstallPwdV.setVisible(false);
            if (this.apkInformation.getBuildInstallType().equals("1")) {
                this.tvInstallTypeV.setText("\u516c\u5f00\u5b89\u88c5");
            } else {
                this.tvInstallTypeV.setText("\u9080\u8bf7\u5b89\u88c5");
            }
        }
        this.tvApiKeyV.setText(this.apkInformation.getApi_key());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UploadFileDialog.this.onClose();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadFileDialog.this.onClose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void onUp() {
        UpLoadInfoDialog upLoadInfoDialog = new UpLoadInfoDialog(this.project);
        upLoadInfoDialog.setTitle("\u84b2\u516c\u82f1");
        this.dispose();
        upLoadInfoDialog.setVisible(true);
    }

    private void onClose() {
        this.dispose();
    }

    public static void main(String[] args) {
    }

    public void uploadBuild() {
        this.btnUpload.setEnabled(false);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("_api_key", this.apkInformation.getApi_key());
        if (!TextUtils.isEmpty((CharSequence)this.apkInformation.getBuildChannelShortcut())) {
            params.put("buildChannelShortcut", this.apkInformation.getBuildChannelShortcut());
        }
        params.put("buildInstallType", this.apkInformation.getBuildInstallType());
        if (this.apkInformation.getBuildInstallType() == "2") {
            params.put("buildPassword", this.apkInformation.getBuildPassword());
        }
        if (!TextUtils.isEmpty((CharSequence)this.apkInformation.getTextlog())) {
            params.put("buildUpdateDescription", this.apkInformation.getTextlog());
        }
        File uploadFile = new File(this.apkInformation.getFilePath());
        this.uploadService.uploadFileToServer(params, uploadFile, this);
    }

    @Override
    public void onUploadFinished(boolean param1Boolean, int code) {
        if (!param1Boolean) {
            this.progressBar.setVisible(false);
            this.btnUpload.setEnabled(true);
            this.tvUploadSuccessful.setVisible(true);
            this.tvUploadSuccessful.setText("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5APIKEY\u662f\u5426\u6b63\u786e" + code);
            return;
        }
        this.progressBar.setVisible(false);
        this.btnUpload.setEnabled(false);
        this.tvDownLoadV.setVisible(true);
        this.tvDownLoadT.setVisible(true);
        this.tvUploadSuccessful.setVisible(true);
        this.tvUploadSuccessful.setText("\u4e0a\u4f20\u6210\u529f");
        this.tvDownLoadV.setText(ApkInformation.getInstance().getaShort() + "  \u70b9\u51fb\u6253\u5f00");
    }

    @Override
    public void onPackageSizeComputed(long param1Long) {
        this.progressBar.setMaximum((int)param1Long);
    }

    @Override
    public void onProgressChanged(float param1Long) {
        this.progressBar.setValue((int)param1Long);
    }

    @Override
    public void onUploadError(int code, String error) {
        this.progressBar.setVisible(false);
        this.btnUpload.setEnabled(true);
        this.tvUploadSuccessful.setVisible(true);
        this.tvUploadSuccessful.setText("\u4e0a\u4f20\u5931\u8d25" + error);
    }

    public void browserUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private Window getParentWindow(Project project) {
        Window focusedWindow;
        WindowManagerEx windowManager = (WindowManagerEx)WindowManager.getInstance();
        Window window = windowManager.suggestParentWindow(project);
        if (window == null && (focusedWindow = windowManager.getMostRecentFocusedWindow()) instanceof IdeFrameImpl) {
            window = focusedWindow;
        }
        return window;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JButton jButton;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JProgressBar jProgressBar;
        JLabel jLabel5;
        JLabel jLabel6;
        JLabel jLabel7;
        JLabel jLabel8;
        JLabel jLabel9;
        JLabel jLabel10;
        JLabel jLabel11;
        JLabel jLabel12;
        JLabel jLabel13;
        JLabel jLabel14;
        JLabel jLabel15;
        JLabel jLabel16;
        JLabel jLabel17;
        JLabel jLabel18;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(8, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel.setMinimumSize(new Dimension(400, 320));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.btnUp = jButton3 = new JButton();
        jButton3.setText("\u4e0a\u4e00\u6b65");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.btnClose = jButton2 = new JButton();
        jButton2.setText("\u5173\u95ed");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.tvNameT = jLabel18 = new JLabel();
        jLabel18.setText("\u540d\u79f0");
        jPanel4.add((Component)jLabel18, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.tvNameV = jLabel17 = new JLabel();
        ((Component)jLabel17).setForeground(new Color(-15024996));
        jLabel17.setText("");
        jPanel4.add((Component)jLabel17, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tvVersionT = jLabel16 = new JLabel();
        jLabel16.setText("\u7248\u672c\u53f7");
        jPanel4.add((Component)jLabel16, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.tvVersionV = jLabel15 = new JLabel();
        ((Component)jLabel15).setForeground(new Color(-15024996));
        jLabel15.setText("");
        jPanel4.add((Component)jLabel15, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tvPackageNameT = jLabel14 = new JLabel();
        jLabel14.setText("\u5305\u540d");
        jPanel4.add((Component)jLabel14, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.tvPackageNameV = jLabel13 = new JLabel();
        ((Component)jLabel13).setForeground(new Color(-15024996));
        jLabel13.setText("");
        jPanel4.add((Component)jLabel13, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tvChannelT = jLabel12 = new JLabel();
        jLabel12.setText("\u6e20\u9053\u53f7");
        jPanel4.add((Component)jLabel12, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.tvChannelV = jLabel11 = new JLabel();
        ((Component)jLabel11).setForeground(new Color(-15024996));
        jLabel11.setText("");
        jPanel4.add((Component)jLabel11, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tvInstallTypeT = jLabel10 = new JLabel();
        jLabel10.setText("\u5b89\u88c5\u65b9\u5f0f");
        jPanel4.add((Component)jLabel10, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.tvInstallTypeV = jLabel9 = new JLabel();
        ((Component)jLabel9).setForeground(new Color(-15024996));
        jLabel9.setText("");
        jPanel4.add((Component)jLabel9, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tvInstallPwdT = jLabel8 = new JLabel();
        jLabel8.setText("\u5b89\u88c5\u5bc6\u7801");
        jPanel4.add((Component)jLabel8, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.tvInstallPwdV = jLabel7 = new JLabel();
        ((Component)jLabel7).setForeground(new Color(-15024996));
        jLabel7.setText("");
        jPanel4.add((Component)jLabel7, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tvApiKeyT = jLabel6 = new JLabel();
        jLabel6.setText("APIKEY");
        jPanel4.add((Component)jLabel6, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.tvApiKeyV = jLabel5 = new JLabel();
        ((Component)jLabel5).setForeground(new Color(-15024996));
        jLabel5.setText("");
        jPanel4.add((Component)jLabel5, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.progressBar = jProgressBar = new JProgressBar();
        jPanel5.add((Component)jProgressBar, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(200, -1), new Dimension(200, -1), null));
        this.tvUploadSuccessful = jLabel4 = new JLabel();
        ((Component)jLabel4).setForeground(new Color(-4509394));
        jLabel4.setText("\u4e0a\u4f20\u6210\u529f");
        ((Component)jLabel4).setVisible(false);
        jPanel5.add((Component)jLabel4, new GridConstraints(1, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.tvDownLoadT = jLabel3 = new JLabel();
        jLabel3.setText("\u4e0b\u8f7d\u7aef\u94fe\u63a5");
        ((Component)jLabel3).setVisible(false);
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.tvDownLoadV = jLabel2 = new JLabel();
        ((Component)jLabel2).setForeground(new Color(-15024996));
        jLabel2.setText("");
        ((Component)jLabel2).setVisible(false);
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.btnUpload = jButton = new JButton();
        ((Component)jButton).setForeground(new Color(-15024996));
        jButton.setText("\u70b9\u51fb\u4e0a\u4f20");
        jPanel.add((Component)jButton, new GridConstraints(5, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.iconimage = jLabel = new JLabel();
        jLabel.setText("");
        jPanel7.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel7.add((Component)spacer6, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel7.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

