/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResourceLoader {
    public static Map<Integer, String> loadSystemAttrIds() {
        InputStream in = ResourceLoader.class.getResourceAsStream("/r_values.xml");
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            final HashMap<Integer, String> map = new HashMap<Integer, String>();
            DefaultHandler dh = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (!qName.equals("public")) {
                        return;
                    }
                    String type = attributes.getValue("type");
                    if (type == null) {
                        return;
                    }
                    if (type.equals("attr")) {
                        String idStr = attributes.getValue("id");
                        String name = attributes.getValue("name");
                        if (idStr.startsWith("0x")) {
                            idStr = idStr.substring(2);
                        }
                        int id = Integer.parseInt(idStr, 16);
                        map.put(id, name);
                    }
                }
            };
            parser.parse(in, dh);
            HashMap<Integer, String> hashMap = map;
            return hashMap;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignored) {}
        }
    }

    public static Map<Integer, String> loadSystemStyles() {
        InputStream in = ResourceLoader.class.getResourceAsStream("/r_styles.conf");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                String[] items = line.split("=");
                int id = Integer.parseInt(items[1].trim());
                String name = items[0].trim();
                map.put(id, name);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignored) {}
        }
        return map;
    }
}

