/*
 * Decompiled with CFR 0.152.
 */
package com.pgyer.uploadpugin.entity;

import java.io.File;
import java.io.IOException;
import net.dongliu.apk.parser.ApkParser;
import net.dongliu.apk.parser.bean.ApkMeta;

public class ApkInformation {
    public String name;
    public String icon;
    public String bundleId;
    public String aShort;
    public String versionName;
    public String versionCode;
    public String buildInstallType;
    public String buildPassword;
    public String buildChannelShortcut = "";
    public String filePath;
    private String textlog = "";
    private String api_key = "";
    private boolean back = false;
    private static ApkInformation apkInformation = new ApkInformation();

    public boolean isBack() {
        return this.back;
    }

    public void setBack(boolean back) {
        this.back = back;
    }

    private ApkInformation() {
    }

    private ApkInformation(String url) {
        this.filePath = url;
        this.parseApk(url);
    }

    public static ApkInformation getInstance() {
        if (apkInformation == null) {
            return new ApkInformation();
        }
        return apkInformation;
    }

    public void initPath(String url) {
        this.filePath = url;
        if (this.filePath.isEmpty()) {
            return;
        }
        this.parseApk(this.filePath);
        this.setFilePath(url);
    }

    public void parseApk(String url) {
        ApkParser apkParser = null;
        try {
            apkParser = new ApkParser(new File(url));
            ApkMeta apkMeta = apkParser.getApkMeta();
            this.versionName = apkMeta.getVersionName();
            this.versionCode = apkMeta.getVersionCode().toString();
            this.bundleId = apkMeta.getPackageName();
            this.name = apkMeta.getLabel();
            this.icon = apkMeta.getIcon().getPath();
            apkParser.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getVersionCode() {
        return this.versionCode;
    }

    public void setVersionCode(String versionCode) {
        this.versionCode = versionCode;
    }

    public String getaShort() {
        return this.aShort;
    }

    public void setaShort(String aShort) {
        this.aShort = aShort;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getTextlog() {
        return this.textlog;
    }

    public void setTextlog(String textlog) {
        this.textlog = textlog;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public String getBuildInstallType() {
        return this.buildInstallType;
    }

    public void setBuildInstallType(String buildInstallType) {
        this.buildInstallType = buildInstallType;
    }

    public String getBuildPassword() {
        return this.buildPassword;
    }

    public void setBuildPassword(String buildPassword) {
        this.buildPassword = buildPassword;
    }

    public String getBuildChannelShortcut() {
        return this.buildChannelShortcut;
    }

    public void setBuildChannelShortcut(String buildChannelShortcut) {
        this.buildChannelShortcut = buildChannelShortcut;
    }

    public String getApi_key() {
        return this.api_key;
    }

    public void setApi_key(String api_key) {
        this.api_key = api_key;
    }

    public void cleanCache() {
        this.setName("");
        this.setTextlog("");
        this.setBuildPassword("");
        this.setBuildInstallType("1");
        this.setBuildChannelShortcut("");
        this.setFilePath("");
        this.setVersionCode("");
        this.setVersionName("");
        this.setIcon("");
        this.setaShort("");
        this.bundleId = "";
        this.setBack(false);
    }
}

