/*
 * Decompiled with CFR 0.152.
 */
package com.pgyer.uploadpugin.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.pgyer.uploadpugin.entity.ApkInformation;
import com.pgyer.uploadpugin.ui.UploadFileDialog;
import com.pgyer.uploadpugin.utils.SearchFile;
import com.pgyer.uploadpugin.utils.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.http.util.TextUtils;

public class UpLoadInfoDialog
extends JDialog {
    private JPanel contentPane;
    private JButton btnCancel;
    private JButton btnOK;
    private JEditorPane edUpdataInfo;
    private JLabel apkPath;
    private JButton btnCheck;
    private JTextField tvPwd;
    private JLabel tfPwdT;
    private JRadioButton rb1;
    private JRadioButton rb2;
    private JRadioButton rb3;
    private JTextField tvChannel;
    private JTextField fdApiKeyV;
    private JLabel lbApiKeyG;
    private JLabel lbQuDaoG;
    public String apkAbsolutePath;
    public ApkInformation apkInformation;
    public String buildInstallType = "1";
    public Color mainColor;
    private Project project;

    public UpLoadInfoDialog(Project project) {
        this.project = project;
        this.$$$setupUI$$$();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.apkInformation = ApkInformation.getInstance();
        this.mainColor = new Color(187, 187, 187);
        this.setResizable(false);
        this.setMinimumSize(new Dimension(510, 460));
        this.setLocationRelativeTo(this.getParentWindow(project));
        this.getRootPane().setDefaultButton(this.btnOK);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpLoadInfoDialog.this.onCancel();
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpLoadInfoDialog.this.onOK();
            }
        });
        this.btnCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileType type = FileTypeManager.getInstance().getFileTypeByExtension("apk");
                FileChooserDescriptor descriptor = Utils.createSingleFileDescriptor(type);
                descriptor.setTitle("APK File");
                descriptor.setDescription("");
                VirtualFile fileToSelect = ProjectManager.getInstance().getOpenProjects()[0].getProjectFile();
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, (VirtualFile)fileToSelect, (Consumer)new FileChooser.FileChooserConsumer(){

                    public void consume(List<VirtualFile> virtualFiles) {
                        String filePath = virtualFiles.get(0).getPath();
                        File file = new File(filePath);
                        if (!file.exists() || !filePath.toLowerCase().contains(".apk")) {
                            filePath = "";
                            Messages.showErrorDialog((String)"\u8bf7\u9009\u62e9.apk\u6587\u4ef6", (String)"\u9519\u8bef\u63d0\u793a");
                        } else {
                            UpLoadInfoDialog.this.apkAbsolutePath = filePath;
                            UpLoadInfoDialog.this.btnCheck.setText("\u91cd\u65b0\u9009\u62e9\u6587\u4ef6");
                            UpLoadInfoDialog.this.apkPath.setText(UpLoadInfoDialog.this.splitPath(filePath));
                            UpLoadInfoDialog.this.apkInformation.initPath(UpLoadInfoDialog.this.apkAbsolutePath);
                            UpLoadInfoDialog.this.apkInformation.setFilePath(UpLoadInfoDialog.this.apkAbsolutePath);
                            SearchFile.getInstance().initPath(UpLoadInfoDialog.this.apkInformation.filePath);
                        }
                    }

                    public void cancelled() {
                        Messages.showErrorDialog((String)"\u8bf7\u9009\u62e9.apk\u6587\u4ef6", (String)"\u9519\u8bef\u63d0\u793a");
                    }
                });
            }
        });
        this.lbApiKeyG.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UpLoadInfoDialog.this.browserUrl("http://www.pgyer.com/account/index");
                UpLoadInfoDialog.this.lbApiKeyG.setForeground(UpLoadInfoDialog.this.mainColor);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.lbQuDaoG.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UpLoadInfoDialog.this.browserUrl("https://www.pgyer.com/manager/dashboard/app/");
                UpLoadInfoDialog.this.lbQuDaoG.setForeground(UpLoadInfoDialog.this.mainColor);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.rb1);
        group.add(this.rb2);
        group.add(this.rb3);
        this.rb1.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpLoadInfoDialog.this.buildInstallType = "1";
                UpLoadInfoDialog.this.tfPwdT.setVisible(false);
                UpLoadInfoDialog.this.tvPwd.setVisible(false);
            }
        });
        this.rb2.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpLoadInfoDialog.this.buildInstallType = "2";
                UpLoadInfoDialog.this.tfPwdT.setVisible(true);
                UpLoadInfoDialog.this.tvPwd.setVisible(true);
            }
        });
        this.rb3.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpLoadInfoDialog.this.buildInstallType = "3";
                UpLoadInfoDialog.this.tfPwdT.setVisible(false);
                UpLoadInfoDialog.this.tvPwd.setVisible(false);
            }
        });
        this.rb1.setSelected(true);
        this.tfPwdT.setVisible(false);
        this.tvPwd.setVisible(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UpLoadInfoDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpLoadInfoDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.intViewData();
    }

    private void intViewData() {
        if (!TextUtils.isEmpty((CharSequence)this.apkInformation.getApi_key())) {
            this.fdApiKeyV.setText(this.apkInformation.getApi_key());
        }
        if (this.apkInformation.isBack()) {
            if (!TextUtils.isEmpty((CharSequence)this.apkInformation.getBuildChannelShortcut())) {
                this.tvChannel.setText(this.apkInformation.getBuildChannelShortcut());
            }
            if (this.apkInformation.getBuildInstallType().equals("2")) {
                this.rb2.setSelected(true);
                this.tfPwdT.setVisible(true);
                this.tvPwd.setVisible(true);
                this.tvPwd.setText(this.apkInformation.getBuildPassword());
            } else if (this.apkInformation.getBuildInstallType().equals("1")) {
                this.rb1.setSelected(true);
                this.tfPwdT.setVisible(false);
                this.tvPwd.setVisible(false);
            } else {
                this.rb3.setSelected(true);
                this.tfPwdT.setVisible(false);
                this.tvPwd.setVisible(false);
            }
            this.apkAbsolutePath = this.apkInformation.getFilePath();
            this.btnCheck.setText("\u91cd\u65b0\u9009\u62e9\u6587\u4ef6");
            this.apkPath.setText(this.splitPath(this.apkInformation.getFilePath()));
            if (!TextUtils.isEmpty((CharSequence)this.apkInformation.getTextlog())) {
                this.edUpdataInfo.setText(this.apkInformation.getTextlog());
            }
        }
    }

    private void onOK() {
        if (TextUtils.isEmpty((CharSequence)this.fdApiKeyV.getText())) {
            Messages.showErrorDialog((String)"APIKEY\u4e0d\u80fd\u4e3a\u7a7a", (String)"\u9519\u8bef\u63d0\u793a");
            return;
        }
        this.apkInformation.setApi_key(this.fdApiKeyV.getText());
        this.apkInformation.setBuildInstallType(this.buildInstallType);
        if (this.buildInstallType.equals("2")) {
            if (TextUtils.isEmpty((CharSequence)this.tvPwd.getText())) {
                Messages.showErrorDialog((String)"\u8bf7\u8f93\u5165\u5b89\u88c5\u5bc6\u7801", (String)"\u9519\u8bef\u63d0\u793a");
                return;
            }
            this.apkInformation.setBuildPassword(this.tvPwd.getText());
        }
        if (!TextUtils.isEmpty((CharSequence)this.tvChannel.getText())) {
            this.apkInformation.setBuildChannelShortcut(this.tvChannel.getText());
        } else {
            this.apkInformation.setBuildChannelShortcut("");
        }
        if (TextUtils.isEmpty((CharSequence)this.apkAbsolutePath)) {
            Messages.showErrorDialog((String)"\u8bf7\u9009\u62e9.apk\u6587\u4ef6", (String)"\u9519\u8bef\u63d0\u793a");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.edUpdataInfo.getText())) {
            this.apkInformation.setTextlog(this.edUpdataInfo.getText());
        } else {
            this.apkInformation.setTextlog("");
        }
        UploadFileDialog uploadFileDialog = new UploadFileDialog(this.project);
        uploadFileDialog.setTitle("\u4e0a\u4f20\u5b89\u88c5\u5305");
        this.apkInformation.setBack(true);
        this.dispose();
        uploadFileDialog.setVisible(true);
    }

    private void onCancel() {
        this.dispose();
    }

    public String getApkPath() {
        return this.apkPath.getText();
    }

    public void browserUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public String parsefilePath(String filePath) {
        File file;
        if (filePath == null) {
            filePath = "";
        }
        if (!(file = new File(filePath)).exists() || filePath.toLowerCase().indexOf(".apk") < 0) {
            filePath = "";
        }
        return filePath;
    }

    public String splitPath(String filep) {
        String rt = "";
        if (filep == null) {
            filep = "";
        }
        if (((String)filep).length() > 40) {
            filep = "..." + ((String)filep).substring(((String)filep).length() - 40, ((String)filep).length());
        }
        return filep;
    }

    public static void main(String[] args) {
    }

    private Window getParentWindow(Project project) {
        Window focusedWindow;
        WindowManagerEx windowManager = (WindowManagerEx)WindowManager.getInstance();
        Window window = windowManager.suggestParentWindow(project);
        if (window == null && (focusedWindow = windowManager.getMostRecentFocusedWindow()) instanceof IdeFrameImpl) {
            window = focusedWindow;
        }
        return window;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JTextField jTextField;
        JTextField jTextField2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JLabel jLabel3;
        JTextField jTextField3;
        JButton jButton;
        JLabel jLabel4;
        JEditorPane jEditorPane;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel.setMinimumSize(new Dimension(454, 460));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.btnCancel = jButton3 = new JButton();
        jButton3.setText("\u53d6\u6d88");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.btnOK = jButton2 = new JButton();
        jButton2.setText("\u4e0b\u4e00\u6b65");
        jPanel3.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setInheritsPopupMenu(false);
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, new Dimension(450, -1), new Dimension(450, -1), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("\u66f4\u65b0Log");
        jPanel4.add((Component)jLabel5, new GridConstraints(7, 0, 1, 1, 5, 0, 0, 0, null, null, null));
        this.edUpdataInfo = jEditorPane = new JEditorPane();
        ((Component)jEditorPane).setBackground(new Color(-12236470));
        jEditorPane.setText("");
        jPanel4.add((Component)jEditorPane, new GridConstraints(7, 1, 1, 1, 0, 3, 6, 6, new Dimension(-1, 150), new Dimension(-1, 150), null));
        this.apkPath = jLabel4 = new JLabel();
        jLabel4.setText("");
        jPanel4.add((Component)jLabel4, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, new Dimension(-1, 25), new Dimension(-1, 25), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("\u9009\u62e9\u6587\u4ef6\u8def\u5f84");
        jPanel4.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, new Dimension(-1, 20), new Dimension(-1, 20), null));
        this.btnCheck = jButton = new JButton();
        jButton.setText("\u9009\u62e9\u672c\u5730\u6587\u4ef6");
        jPanel4.add((Component)jButton, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.tvPwd = jTextField3 = new JTextField();
        jPanel4.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, new Dimension(230, -1), new Dimension(230, -1), null));
        this.tfPwdT = jLabel3 = new JLabel();
        jLabel3.setText("\u5b89\u88c5\u5bc6\u7801");
        jPanel4.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, new Dimension(-1, 20), new Dimension(-1, 20), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.rb1 = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("\u516c\u5f00");
        jPanel5.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, new Dimension(70, -1), null, null));
        this.rb2 = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("\u5bc6\u7801");
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, new Dimension(70, -1), null, null));
        this.rb3 = jRadioButton = new JRadioButton();
        jRadioButton.setText("\u9080\u8bf7");
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, new Dimension(70, -1), null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("\u5b89\u88c5\u65b9\u5f0f");
        jPanel4.add((Component)jLabel7, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, new Dimension(-1, 20), new Dimension(-1, 20), null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("\u6e20\u9053\u53f7");
        jPanel4.add((Component)jLabel8, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, new Dimension(-1, 20), new Dimension(-1, 20), null));
        this.tvChannel = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, new Dimension(230, -1), new Dimension(230, -1), null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("(\u9009\u586b)\u5982\u679c\u662f\u6e20\u9053\u5305\uff0c\u53ea\u53ef\u6307\u5b9a\u4e00\u4e2a\u6e20\u9053");
        jPanel4.add((Component)jLabel9, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, new Dimension(-1, 20), new Dimension(-1, 20), null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("APIKEY");
        jPanel4.add((Component)jLabel10, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, new Dimension(-1, 20), new Dimension(-1, 20), null));
        this.fdApiKeyV = jTextField = new JTextField();
        jTextField.setText("");
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, new Dimension(230, -1), new Dimension(230, -1), null));
        this.lbApiKeyG = jLabel2 = new JLabel();
        ((Component)jLabel2).setForeground(new Color(-15024996));
        jLabel2.setText("\u70b9\u51fb\u83b7\u53d6");
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, new Dimension(-1, 20), new Dimension(-1, 20), null));
        this.lbQuDaoG = jLabel = new JLabel();
        ((Component)jLabel).setForeground(new Color(-15024996));
        jLabel.setText("\u70b9\u51fb\u83b7\u53d6");
        jPanel4.add((Component)jLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, new Dimension(-1, 20), new Dimension(-1, 20), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

