/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.dongliu.apk.parser.bean.DexClass;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.StringPoolEntry;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.dex.DexClassStruct;
import net.dongliu.apk.parser.struct.dex.DexHeader;
import net.dongliu.apk.parser.utils.Buffers;

public class DexParser {
    private ByteBuffer buffer;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private static final int NO_INDEX = -1;
    private DexClass[] dexClasses;

    public DexParser(ByteBuffer buffer) {
        this.buffer = buffer.duplicate();
        this.buffer.order(this.byteOrder);
    }

    public void parse() {
        int i;
        String magic = new String(Buffers.readBytes(this.buffer, 8));
        if (!magic.startsWith("dex\n")) {
            return;
        }
        int version = Integer.parseInt(magic.substring(4, 7));
        if (version < 35) {
            throw new ParserException("Dex file version: " + version + " is not supported");
        }
        DexHeader header = this.readDexHeader();
        header.version = version;
        long[] stringOffsets = this.readStringPool(header.stringIdsOff, header.stringIdsSize);
        int[] typeIds = this.readTypes(header.typeIdsOff, header.typeIdsSize);
        DexClassStruct[] dexClassStructs = this.readClass(header.classDefsOff, header.classDefsSize);
        StringPool stringpool = this.readStrings(stringOffsets);
        String[] types = new String[typeIds.length];
        for (i = 0; i < typeIds.length; ++i) {
            types[i] = stringpool.get(typeIds[i]);
        }
        this.dexClasses = new DexClass[dexClassStructs.length];
        for (i = 0; i < this.dexClasses.length; ++i) {
            this.dexClasses[i] = new DexClass();
        }
        for (i = 0; i < dexClassStructs.length; ++i) {
            DexClassStruct dexClassStruct = dexClassStructs[i];
            DexClass dexClass = this.dexClasses[i];
            dexClass.setClassType(types[dexClassStruct.classIdx]);
            if (dexClassStruct.superclassIdx != -1) {
                dexClass.setSuperClass(types[dexClassStruct.superclassIdx]);
            }
            dexClass.setAccessFlags(dexClassStruct.accessFlags);
        }
    }

    private DexClassStruct[] readClass(long classDefsOff, int classDefsSize) {
        this.buffer.position((int)classDefsOff);
        DexClassStruct[] dexClassStructs = new DexClassStruct[classDefsSize];
        for (int i = 0; i < classDefsSize; ++i) {
            DexClassStruct dexClassStruct = new DexClassStruct();
            dexClassStruct.classIdx = this.buffer.getInt();
            dexClassStruct.accessFlags = this.buffer.getInt();
            dexClassStruct.superclassIdx = this.buffer.getInt();
            dexClassStruct.interfacesOff = Buffers.readUInt(this.buffer);
            dexClassStruct.sourceFileIdx = this.buffer.getInt();
            dexClassStruct.annotationsOff = Buffers.readUInt(this.buffer);
            dexClassStruct.classDataOff = Buffers.readUInt(this.buffer);
            dexClassStruct.staticValuesOff = Buffers.readUInt(this.buffer);
            dexClassStructs[i] = dexClassStruct;
        }
        return dexClassStructs;
    }

    private int[] readTypes(long typeIdsOff, int typeIdsSize) {
        this.buffer.position((int)typeIdsOff);
        int[] typeIds = new int[typeIdsSize];
        for (int i = 0; i < typeIdsSize; ++i) {
            typeIds[i] = (int)Buffers.readUInt(this.buffer);
        }
        return typeIds;
    }

    private StringPool readStrings(long[] offsets) {
        StringPoolEntry[] entries = new StringPoolEntry[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            entries[i] = new StringPoolEntry(i, offsets[i]);
        }
        String lastStr = null;
        long lastOffset = -1L;
        StringPool stringpool = new StringPool(offsets.length);
        for (StringPoolEntry entry : entries) {
            String str;
            if (entry.getOffset() == lastOffset) {
                stringpool.set(entry.getIdx(), lastStr);
                continue;
            }
            this.buffer.position((int)entry.getOffset());
            lastOffset = entry.getOffset();
            lastStr = str = this.readString();
            stringpool.set(entry.getIdx(), str);
        }
        return stringpool;
    }

    private long[] readStringPool(long stringIdsOff, int stringIdsSize) {
        this.buffer.position((int)stringIdsOff);
        long[] offsets = new long[stringIdsSize];
        for (int i = 0; i < stringIdsSize; ++i) {
            offsets[i] = Buffers.readUInt(this.buffer);
        }
        return offsets;
    }

    private String readString() {
        int strLen = this.readVarInts();
        return Buffers.readString(this.buffer, strLen);
    }

    @Deprecated
    private String readString(int strLen) {
        char[] chars = new char[strLen];
        for (int i = 0; i < strLen; ++i) {
            short b;
            short a = Buffers.readUByte(this.buffer);
            if ((a & 0x80) == 0) {
                chars[i] = (char)a;
            } else if ((a & 0xE0) == 192) {
                b = Buffers.readUByte(this.buffer);
                chars[i] = (char)((a & 0x1F) << 6 | b & 0x3F);
            } else if ((a & 0xF0) == 224) {
                b = Buffers.readUByte(this.buffer);
                short c = Buffers.readUByte(this.buffer);
                chars[i] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
            } else if ((a & 0xF0) == 240) {
                // empty if block
            }
            if (chars[i] != '\u0000') continue;
        }
        return new String(chars);
    }

    private int readVarInts() {
        short s;
        int i = 0;
        int count = 0;
        do {
            if (count > 4) {
                throw new ParserException("read varints error.");
            }
            s = Buffers.readUByte(this.buffer);
            i |= (s & 0x7F) << count * 7;
            ++count;
        } while ((s & 0x80) != 0);
        return i;
    }

    private DexHeader readDexHeader() {
        this.buffer.getInt();
        Buffers.readBytes(this.buffer, 20);
        DexHeader header = new DexHeader();
        header.fileSize = Buffers.readUInt(this.buffer);
        header.headerSize = Buffers.readUInt(this.buffer);
        Buffers.readUInt(this.buffer);
        header.linkSize = Buffers.readUInt(this.buffer);
        header.linkOff = Buffers.readUInt(this.buffer);
        header.mapOff = Buffers.readUInt(this.buffer);
        header.stringIdsSize = this.buffer.getInt();
        header.stringIdsOff = Buffers.readUInt(this.buffer);
        header.typeIdsSize = this.buffer.getInt();
        header.typeIdsOff = Buffers.readUInt(this.buffer);
        header.protoIdsSize = this.buffer.getInt();
        header.protoIdsOff = Buffers.readUInt(this.buffer);
        header.fieldIdsSize = this.buffer.getInt();
        header.fieldIdsOff = Buffers.readUInt(this.buffer);
        header.methodIdsSize = this.buffer.getInt();
        header.methodIdsOff = Buffers.readUInt(this.buffer);
        header.classDefsSize = this.buffer.getInt();
        header.classDefsOff = Buffers.readUInt(this.buffer);
        header.dataSize = this.buffer.getInt();
        header.dataOff = Buffers.readUInt(this.buffer);
        this.buffer.position((int)header.headerSize);
        return header;
    }

    public DexClass[] getDexClasses() {
        return this.dexClasses;
    }
}

