/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.struct.ChunkHeader;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.StringPoolHeader;
import net.dongliu.apk.parser.struct.resource.PackageHeader;
import net.dongliu.apk.parser.struct.resource.ResTableConfig;
import net.dongliu.apk.parser.struct.resource.ResourceEntry;
import net.dongliu.apk.parser.struct.resource.ResourceMapEntry;
import net.dongliu.apk.parser.struct.resource.ResourcePackage;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.struct.resource.ResourceTableHeader;
import net.dongliu.apk.parser.struct.resource.ResourceTableMap;
import net.dongliu.apk.parser.struct.resource.Type;
import net.dongliu.apk.parser.struct.resource.TypeHeader;
import net.dongliu.apk.parser.struct.resource.TypeSpec;
import net.dongliu.apk.parser.struct.resource.TypeSpecHeader;
import net.dongliu.apk.parser.utils.Buffers;
import net.dongliu.apk.parser.utils.ParseUtils;

public class ResourceTableParser {
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private StringPool stringPool;
    private ByteBuffer buffer;
    private ResourceTable resourceTable;
    private Set<Locale> locales;

    public ResourceTableParser(ByteBuffer buffer) {
        this.buffer = buffer.duplicate();
        this.buffer.order(this.byteOrder);
        this.locales = new HashSet<Locale>();
    }

    public void parse() {
        ResourceTableHeader resourceTableHeader = (ResourceTableHeader)this.readChunkHeader();
        this.stringPool = ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader());
        this.resourceTable = new ResourceTable();
        this.resourceTable.stringPool = this.stringPool;
        PackageHeader packageHeader = (PackageHeader)this.readChunkHeader();
        int i = 0;
        while ((long)i < resourceTableHeader.packageCount) {
            PackageHeader[] packageHeaders = new PackageHeader[1];
            ResourcePackage resourcePackage = this.readPackage(packageHeader, packageHeaders);
            this.resourceTable.addPackage(resourcePackage);
            packageHeader = packageHeaders[0];
            ++i;
        }
    }

    private ResourcePackage readPackage(PackageHeader packageHeader, PackageHeader[] packageHeaders) {
        ResourcePackage resourcePackage = new ResourcePackage(packageHeader);
        long beginPos = this.buffer.position();
        if (packageHeader.typeStrings > 0L) {
            this.buffer.position((int)(beginPos + packageHeader.typeStrings - (long)packageHeader.headerSize));
            resourcePackage.typeStringPool = ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader());
        }
        if (packageHeader.keyStrings > 0L) {
            this.buffer.position((int)(beginPos + packageHeader.keyStrings - (long)packageHeader.headerSize));
            resourcePackage.keyStringPool = ParseUtils.readStringPool(this.buffer, (StringPoolHeader)this.readChunkHeader());
        }
        block5: while (this.buffer.hasRemaining()) {
            ChunkHeader chunkHeader = this.readChunkHeader();
            switch (chunkHeader.chunkType) {
                case 514: {
                    long typeSpecChunkBegin = this.buffer.position();
                    TypeSpecHeader typeSpecHeader = (TypeSpecHeader)chunkHeader;
                    long[] entryFlags = new long[(int)typeSpecHeader.entryCount];
                    int i = 0;
                    while ((long)i < typeSpecHeader.entryCount) {
                        entryFlags[i] = Buffers.readUInt(this.buffer);
                        ++i;
                    }
                    TypeSpec typeSpec = new TypeSpec(typeSpecHeader);
                    typeSpec.entryFlags = entryFlags;
                    typeSpec.name = resourcePackage.typeStringPool.get(typeSpecHeader.id - 1);
                    resourcePackage.addTypeSpec(typeSpec);
                    this.buffer.position((int)(typeSpecChunkBegin + typeSpecHeader.chunkSize - (long)typeSpecHeader.headerSize));
                    break;
                }
                case 513: {
                    long typeChunkBegin = this.buffer.position();
                    TypeHeader typeHeader = (TypeHeader)chunkHeader;
                    long[] offsets = new long[(int)typeHeader.entryCount];
                    int i = 0;
                    while ((long)i < typeHeader.entryCount) {
                        offsets[i] = Buffers.readUInt(this.buffer);
                        ++i;
                    }
                    long entryPos = typeChunkBegin + typeHeader.entriesStart - (long)typeHeader.headerSize;
                    this.buffer.position((int)entryPos);
                    ResourceEntry[] resourceEntries = new ResourceEntry[offsets.length];
                    for (int i2 = 0; i2 < offsets.length; ++i2) {
                        if (offsets[i2] != 0xFFFFFFFFL) {
                            this.buffer.position((int)(entryPos + offsets[i2]));
                            resourceEntries[i2] = this.readResourceEntry(resourcePackage.keyStringPool);
                            continue;
                        }
                        resourceEntries[i2] = null;
                    }
                    Type type = new Type(typeHeader);
                    type.name = resourcePackage.typeStringPool.get(typeHeader.id - 1);
                    type.resourceEntries = resourceEntries;
                    resourcePackage.addType(type);
                    this.locales.add(type.locale);
                    this.buffer.position((int)(typeChunkBegin + typeHeader.chunkSize - (long)typeHeader.headerSize));
                    break;
                }
                case 512: {
                    packageHeaders[0] = (PackageHeader)chunkHeader;
                    break block5;
                }
                default: {
                    throw new ParserException("unexpected chunk type:" + chunkHeader.chunkType);
                }
            }
        }
        return resourcePackage;
    }

    private ResourceEntry readResourceEntry(StringPool keyStringPool) {
        long beginPos = this.buffer.position();
        ResourceEntry resourceEntry = new ResourceEntry();
        resourceEntry.size = Buffers.readUShort(this.buffer);
        resourceEntry.flags = Buffers.readUShort(this.buffer);
        long keyRef = this.buffer.getInt();
        resourceEntry.key = keyStringPool.get((int)keyRef);
        if ((resourceEntry.flags & 1) != 0) {
            ResourceMapEntry resourceMapEntry = new ResourceMapEntry(resourceEntry);
            resourceMapEntry.parent = Buffers.readUInt(this.buffer);
            resourceMapEntry.count = Buffers.readUInt(this.buffer);
            this.buffer.position((int)(beginPos + (long)resourceEntry.size));
            ResourceTableMap[] resourceTableMaps = new ResourceTableMap[(int)resourceMapEntry.count];
            int i = 0;
            while ((long)i < resourceMapEntry.count) {
                resourceTableMaps[i] = this.readResourceTableMap();
                ++i;
            }
            resourceMapEntry.resourceTableMaps = resourceTableMaps;
            return resourceMapEntry;
        }
        this.buffer.position((int)(beginPos + (long)resourceEntry.size));
        resourceEntry.value = ParseUtils.readResValue(this.buffer, this.stringPool);
        return resourceEntry;
    }

    private ResourceTableMap readResourceTableMap() {
        ResourceTableMap resourceTableMap = new ResourceTableMap();
        resourceTableMap.nameRef = Buffers.readUInt(this.buffer);
        resourceTableMap.resValue = ParseUtils.readResValue(this.buffer, this.stringPool);
        if ((resourceTableMap.nameRef & 0x2000000L) != 0L) {
            this.parseArrays(resourceTableMap);
        } else if ((resourceTableMap.nameRef & 0x1000000L) != 0L) {
            this.parseAttrs(resourceTableMap);
        }
        return resourceTableMap;
    }

    private void parseArrays(ResourceTableMap resourceTableMap) {
    }

    private void parseAttrs(ResourceTableMap resourceTableMap) {
        switch ((int)resourceTableMap.nameRef) {
            default: 
        }
    }

    private ChunkHeader readChunkHeader() {
        long begin = this.buffer.position();
        int chunkType = Buffers.readUShort(this.buffer);
        int headerSize = Buffers.readUShort(this.buffer);
        long chunkSize = Buffers.readUInt(this.buffer);
        switch (chunkType) {
            case 2: {
                ResourceTableHeader resourceTableHeader = new ResourceTableHeader(chunkType, headerSize, chunkSize);
                resourceTableHeader.packageCount = Buffers.readUInt(this.buffer);
                this.buffer.position((int)(begin + (long)headerSize));
                return resourceTableHeader;
            }
            case 1: {
                StringPoolHeader stringPoolHeader = new StringPoolHeader(chunkType, headerSize, chunkSize);
                stringPoolHeader.stringCount = Buffers.readUInt(this.buffer);
                stringPoolHeader.styleCount = Buffers.readUInt(this.buffer);
                stringPoolHeader.flags = Buffers.readUInt(this.buffer);
                stringPoolHeader.stringsStart = Buffers.readUInt(this.buffer);
                stringPoolHeader.stylesStart = Buffers.readUInt(this.buffer);
                this.buffer.position((int)(begin + (long)headerSize));
                return stringPoolHeader;
            }
            case 512: {
                PackageHeader packageHeader = new PackageHeader(chunkType, headerSize, chunkSize);
                packageHeader.id = Buffers.readUInt(this.buffer);
                packageHeader.name = ParseUtils.readStringUTF16(this.buffer, 128);
                packageHeader.typeStrings = Buffers.readUInt(this.buffer);
                packageHeader.lastPublicType = Buffers.readUInt(this.buffer);
                packageHeader.keyStrings = Buffers.readUInt(this.buffer);
                packageHeader.lastPublicKey = Buffers.readUInt(this.buffer);
                this.buffer.position((int)(begin + (long)headerSize));
                return packageHeader;
            }
            case 514: {
                TypeSpecHeader typeSpecHeader = new TypeSpecHeader(chunkType, headerSize, chunkSize);
                typeSpecHeader.id = Buffers.readUByte(this.buffer);
                typeSpecHeader.res0 = Buffers.readUByte(this.buffer);
                typeSpecHeader.res1 = Buffers.readUShort(this.buffer);
                typeSpecHeader.entryCount = Buffers.readUInt(this.buffer);
                this.buffer.position((int)(begin + (long)headerSize));
                return typeSpecHeader;
            }
            case 513: {
                TypeHeader typeHeader = new TypeHeader(chunkType, headerSize, chunkSize);
                typeHeader.id = Buffers.readUByte(this.buffer);
                typeHeader.res0 = Buffers.readUByte(this.buffer);
                typeHeader.res1 = Buffers.readUShort(this.buffer);
                typeHeader.entryCount = Buffers.readUInt(this.buffer);
                typeHeader.entriesStart = Buffers.readUInt(this.buffer);
                typeHeader.config = this.readResTableConfig();
                this.buffer.position((int)(begin + (long)headerSize));
                return typeHeader;
            }
        }
        throw new ParserException("Unexpected chunk Type:" + Integer.toHexString(chunkType));
    }

    private ResTableConfig readResTableConfig() {
        long beginPos = this.buffer.position();
        ResTableConfig config = new ResTableConfig();
        long size = Buffers.readUInt(this.buffer);
        Buffers.skip(this.buffer, 4);
        config.language = new String(Buffers.readBytes(this.buffer, 2)).replace("\u0000", "");
        config.country = new String(Buffers.readBytes(this.buffer, 2)).replace("\u0000", "");
        long endPos = this.buffer.position();
        Buffers.skip(this.buffer, (int)(size - (endPos - beginPos)));
        return config;
    }

    public ResourceTable getResourceTable() {
        return this.resourceTable;
    }

    public Set<Locale> getLocales() {
        return this.locales;
    }
}

