/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.utils;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import net.dongliu.apk.parser.bean.Locales;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.StringPoolEntry;
import net.dongliu.apk.parser.struct.ResValue;
import net.dongliu.apk.parser.struct.ResourceEntity;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.StringPoolHeader;
import net.dongliu.apk.parser.struct.resource.ResourceEntry;
import net.dongliu.apk.parser.struct.resource.ResourcePackage;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.struct.resource.Type;
import net.dongliu.apk.parser.struct.resource.TypeSpec;
import net.dongliu.apk.parser.utils.Buffers;

public class ParseUtils {
    public static Charset charsetUTF8 = Charset.forName("UTF-8");

    public static String readString(ByteBuffer buffer, boolean utf8) {
        if (utf8) {
            int strLen = ParseUtils.readLen(buffer);
            int bytesLen = ParseUtils.readLen(buffer);
            byte[] bytes = Buffers.readBytes(buffer, bytesLen);
            String str = new String(bytes, charsetUTF8);
            short trailling = Buffers.readUByte(buffer);
            return str;
        }
        int strLen = ParseUtils.readLen16(buffer);
        String str = Buffers.readString(buffer, strLen);
        int trailling = Buffers.readUShort(buffer);
        return str;
    }

    public static String readStringUTF16(ByteBuffer buffer, int strLen) {
        String str = Buffers.readString(buffer, strLen);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '\u0000') continue;
            return str.substring(0, i);
        }
        return str;
    }

    private static int readLen(ByteBuffer buffer) {
        int len = 0;
        int i = Buffers.readUByte(buffer);
        if ((i & 0x80) != 0) {
            len |= (i & 0x7F) << 7;
            len += Buffers.readUByte(buffer);
        } else {
            len = i;
        }
        return len;
    }

    private static int readLen16(ByteBuffer buffer) {
        int len = 0;
        int i = Buffers.readUShort(buffer);
        if ((i & 0x8000) != 0) {
            len |= (i & Short.MAX_VALUE) << 15;
            len += Buffers.readUShort(buffer);
        } else {
            len = i;
        }
        return len;
    }

    public static StringPool readStringPool(ByteBuffer buffer, StringPoolHeader stringPoolHeader) {
        long beginPos = buffer.position();
        long[] offsets = new long[(int)stringPoolHeader.stringCount];
        if (stringPoolHeader.stringCount > 0L) {
            int idx = 0;
            while ((long)idx < stringPoolHeader.stringCount) {
                offsets[idx] = Buffers.readUInt(buffer);
                ++idx;
            }
        }
        boolean sorted = (stringPoolHeader.flags & 1L) != 0L;
        boolean utf8 = (stringPoolHeader.flags & 0x100L) != 0L;
        long stringPos = beginPos + stringPoolHeader.stringsStart - (long)stringPoolHeader.headerSize;
        buffer.position((int)stringPos);
        StringPoolEntry[] entries = new StringPoolEntry[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            entries[i] = new StringPoolEntry(i, stringPos + offsets[i]);
        }
        String lastStr = null;
        long lastOffset = -1L;
        StringPool stringPool = new StringPool((int)stringPoolHeader.stringCount);
        for (StringPoolEntry entry : entries) {
            String str;
            if (entry.getOffset() == lastOffset) {
                stringPool.set(entry.getIdx(), lastStr);
                continue;
            }
            buffer.position((int)entry.getOffset());
            lastOffset = entry.getOffset();
            lastStr = str = ParseUtils.readString(buffer, utf8);
            stringPool.set(entry.getIdx(), str);
        }
        if (stringPoolHeader.styleCount > 0L) {
            // empty if block
        }
        buffer.position((int)(beginPos + stringPoolHeader.chunkSize - (long)stringPoolHeader.headerSize));
        return stringPool;
    }

    public static String readRGBs(ByteBuffer buffer, int strLen) {
        long l = Buffers.readUInt(buffer);
        StringBuilder sb = new StringBuilder();
        for (int i = strLen / 2 - 1; i >= 0; --i) {
            sb.append(Integer.toHexString((int)(l >> i * 8 & 0xFFL)));
        }
        return sb.toString();
    }

    public static ResourceEntity readResValue(ByteBuffer buffer, StringPool stringPool, boolean isStyle) {
        ResValue resValue = new ResValue();
        resValue.size = Buffers.readUShort(buffer);
        resValue.res0 = Buffers.readUByte(buffer);
        resValue.dataType = Buffers.readUByte(buffer);
        switch (resValue.dataType) {
            case 16: 
            case 17: {
                resValue.data = new ResourceEntity(buffer.getInt());
                break;
            }
            case 3: {
                int strRef = buffer.getInt();
                if (strRef <= 0) break;
                resValue.data = new ResourceEntity(stringPool.get(strRef));
                break;
            }
            case 1: {
                long resourceId = Buffers.readUInt(buffer);
                resValue.data = new ResourceEntity(resourceId, isStyle);
                break;
            }
            case 18: {
                resValue.data = new ResourceEntity(buffer.getInt() != 0);
                break;
            }
            case 0: {
                resValue.data = new ResourceEntity("");
                break;
            }
            case 29: 
            case 31: {
                resValue.data = new ResourceEntity(ParseUtils.readRGBs(buffer, 6));
                break;
            }
            case 28: 
            case 30: {
                resValue.data = new ResourceEntity(ParseUtils.readRGBs(buffer, 8));
                break;
            }
            case 5: {
                resValue.data = new ResourceEntity(ParseUtils.getDimension(buffer));
                break;
            }
            case 6: {
                resValue.data = new ResourceEntity(ParseUtils.getFraction(buffer));
                break;
            }
            default: {
                resValue.data = new ResourceEntity("{" + resValue.dataType + ":" + Buffers.readUInt(buffer) + "}");
            }
        }
        return resValue.data;
    }

    private static String getDimension(ByteBuffer buffer) {
        String unitStr;
        long l = Buffers.readUInt(buffer);
        short unit = (short)(l & 0xFFL);
        switch (unit) {
            case 5: {
                unitStr = "mm";
                break;
            }
            case 0: {
                unitStr = "px";
                break;
            }
            case 1: {
                unitStr = "dp";
                break;
            }
            case 2: {
                unitStr = "sp";
                break;
            }
            case 3: {
                unitStr = "pt";
                break;
            }
            case 4: {
                unitStr = "in";
                break;
            }
            default: {
                unitStr = "unknown unit:0x" + Integer.toHexString(unit);
            }
        }
        return (l >> 8) + unitStr;
    }

    private static String getFraction(ByteBuffer buffer) {
        String pstr;
        long l = Buffers.readUInt(buffer);
        short type = (short)(l & 0xFL);
        switch (type) {
            case 0: {
                pstr = "%";
                break;
            }
            case 1: {
                pstr = "%p";
                break;
            }
            default: {
                pstr = "unknown type:0x" + Integer.toHexString(type);
            }
        }
        float value = Float.intBitsToFloat((int)(l >> 4));
        return value + pstr;
    }

    public static void checkChunkType(int expected, int real) {
        if (expected != real) {
            throw new ParserException("Expect chunk type:" + Integer.toHexString(expected) + ", but got:" + Integer.toHexString(real));
        }
    }

    public static String getResourceById(long resourceId, boolean isStyle, ResourceTable resourceTable, Locale locale) {
        if (isStyle && (resourceId & 0x1030000L) == 0x1030000L) {
            return "@android:style/" + ResourceTable.styleMap.get((int)resourceId);
        }
        String str = "resourceId:0x" + Long.toHexString(resourceId);
        if (resourceTable == null) {
            return str;
        }
        short packageId = (short)(resourceId >> 24 & 0xFFL);
        short typeId = (short)(resourceId >> 16 & 0xFFL);
        int entryIndex = (int)(resourceId & 0xFFFFL);
        ResourcePackage resourcePackage = resourceTable.getPackage(packageId);
        if (resourcePackage == null) {
            return str;
        }
        TypeSpec typeSpec = resourcePackage.getTypeSpec(typeId);
        List<Type> types = resourcePackage.getTypes(typeId);
        if (typeSpec == null || types == null) {
            return str;
        }
        if (!typeSpec.exists(entryIndex)) {
            return str;
        }
        String result = null;
        String ref = null;
        int currentLevel = -1;
        for (Type type : types) {
            ResourceEntry resource = type.getResourceEntry(entryIndex);
            if (resource == null) continue;
            ref = resource.key;
            int level = Locales.match(locale, type.locale);
            if (level == 2) {
                result = resource.toStringValue(resourceTable, locale);
                break;
            }
            if (level <= currentLevel) continue;
            result = resource.toStringValue(resourceTable, locale);
        }
        if (locale == null || result == null) {
            result = "@" + typeSpec.name + "/" + ref;
        }
        return result;
    }

    public static ResourceEntity readResValue(ByteBuffer buffer, StringPool stringPool) {
        return ParseUtils.readResValue(buffer, stringPool, false);
    }
}

